/*
 * Decompiled with CFR 0.152.
 */
package net.conczin.data;

import com.hypixel.hytale.codec.Codec;
import java.util.Collections;
import java.util.List;
import net.conczin.utils.ListCodec;
import net.conczin.utils.RecordCodec;

public record Melody(String name, List<Track> tracks) {
    public static final RecordCodec<Melody> CODEC = RecordCodec.composite("Name", Codec.STRING, Melody::name, "Tracks", new ListCodec<Track>(Track.CODEC), Melody::tracks, Melody::new);

    public record Track(String name, List<Note> notes) {
        private final List<Note> notes;
        public static final RecordCodec<Track> CODEC = RecordCodec.composite("Name", Codec.STRING, Track::name, "Notes", new ListCodec<Note>(Note.CODEC), Track::notes, Track::new);

        public List<Note> notes() {
            return Collections.unmodifiableList(this.notes);
        }

        public void setNotes(List<Note> notes) {
            this.notes.clear();
            this.notes.addAll(notes);
        }
    }

    public record Note(int note, int velocity, int time, int length) {
        public static final RecordCodec<Note> CODEC = RecordCodec.composite("Note", Codec.INTEGER, Note::note, "Velocity", Codec.INTEGER, Note::velocity, "Time", Codec.INTEGER, Note::time, "Length", Codec.INTEGER, Note::time, Note::new);

        public static class Builder {
            public final int note;
            public final int velocity;
            public final int time;
            public int length;

            public Builder(int note, int velocity, int time) {
                this.note = note;
                this.velocity = velocity;
                this.time = time;
            }

            public Note build() {
                return new Note(this.note, this.velocity, this.time, this.length);
            }
        }
    }
}

