/*
 * Decompiled with CFR 0.152.
 */
package net.conczin.data;

import java.io.IOException;
import java.io.InputStream;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.MetaMessage;
import javax.sound.midi.MidiEvent;
import javax.sound.midi.MidiMessage;
import javax.sound.midi.MidiSystem;
import javax.sound.midi.Sequence;
import javax.sound.midi.ShortMessage;
import javax.sound.midi.Track;
import net.conczin.data.Melody;

public class MidiParser {
    public static List<Melody.Track> parseMidi(InputStream inputStream) {
        Sequence sequence;
        LinkedList<Melody.Track> tracks = new LinkedList<Melody.Track>();
        try {
            sequence = MidiSystem.getSequence(inputStream);
        }
        catch (IOException | InvalidMidiDataException e) {
            throw new RuntimeException(e);
        }
        LinkedList sharedEvents = new LinkedList();
        for (Track track : sequence.getTracks()) {
            MidiParser.getEvents(track).stream().filter(event -> {
                MetaMessage m;
                MidiMessage patt0$temp = event.getMessage();
                return patt0$temp instanceof MetaMessage && (m = (MetaMessage)patt0$temp).getType() == 81;
            }).forEach(sharedEvents::add);
        }
        int trackNr = 1;
        for (Track track : sequence.getTracks()) {
            List<MidiEvent> events = MidiParser.getEvents(track);
            events.addAll(0, sharedEvents);
            events.sort((a, b) -> (int)(a.getTick() - b.getTick()));
            double bpm = 120.0;
            long lastTick = 0L;
            double time = 0.0;
            Object name = "Track " + trackNr;
            LinkedList<Melody.Note> notes = new LinkedList<Melody.Note>();
            HashMap<Integer, Melody.Note.Builder> currentNotes = new HashMap<Integer, Melody.Note.Builder>();
            for (MidiEvent event2 : events) {
                int note;
                long tick = event2.getTick();
                double deltaMs = (double)(tick - lastTick) * 60000.0 / ((double)sequence.getResolution() * bpm);
                lastTick = tick;
                int ms = (int)(time += deltaMs);
                MidiMessage message = event2.getMessage();
                if (message instanceof MetaMessage) {
                    MetaMessage metaMessage = (MetaMessage)message;
                    byte[] data = metaMessage.getData();
                    int type = metaMessage.getType();
                    if (type == 3) {
                        String newName = new String(data).strip();
                        if (!newName.isEmpty()) {
                            name = newName;
                        }
                    } else if (type == 81) {
                        int microsecondsPerBeat = (data[0] & 0xFF) << 16 | (data[1] & 0xFF) << 8 | data[2] & 0xFF;
                        bpm = Math.round(6.0E7f / (float)microsecondsPerBeat);
                    }
                }
                if (!(message instanceof ShortMessage)) continue;
                ShortMessage sm = (ShortMessage)message;
                int command = sm.getCommand();
                if (command == 144 && sm.getData2() == 0) {
                    command = 128;
                }
                if (command == 144) {
                    note = sm.getData1();
                    int velocity = sm.getData2();
                    currentNotes.put(note, new Melody.Note.Builder(note, velocity, ms));
                    continue;
                }
                if (command != 128) continue;
                note = sm.getData1();
                Melody.Note.Builder noteBuilder = (Melody.Note.Builder)currentNotes.get(note);
                currentNotes.remove(note);
                if (noteBuilder == null) continue;
                noteBuilder.length = ms - noteBuilder.time;
                notes.add(noteBuilder.build());
            }
            if (notes.isEmpty()) continue;
            ++trackNr;
            notes.sort(Comparator.comparingInt(Melody.Note::time));
            tracks.add(new Melody.Track((String)name, notes));
        }
        int offset = Integer.MAX_VALUE;
        for (Melody.Track track : tracks) {
            List<Melody.Note> notes = track.notes();
            if (notes.isEmpty()) continue;
            offset = Math.min(offset, ((Melody.Note)notes.getFirst()).time());
        }
        int totalVelocity = 0;
        int totalNotes = 0;
        for (Melody.Track track : tracks) {
            for (Melody.Note note : track.notes()) {
                totalVelocity += note.velocity();
                ++totalNotes;
            }
        }
        float averageVelocity = (float)totalVelocity / (float)totalNotes;
        for (Melody.Track track : tracks) {
            LinkedList<Melody.Note> newNotes = new LinkedList<Melody.Note>();
            for (Melody.Note note : track.notes()) {
                newNotes.add(new Melody.Note(note.note(), (int)((float)note.velocity() / averageVelocity * 64.0f), note.time() - offset, note.length()));
            }
            track.setNotes(newNotes);
        }
        return tracks;
    }

    private static List<MidiEvent> getEvents(Track track) {
        LinkedList<MidiEvent> events = new LinkedList<MidiEvent>();
        for (int i = 0; i < track.size(); ++i) {
            events.add(track.get(i));
        }
        return events;
    }
}

