/*
 * Decompiled with CFR 0.152.
 */
package net.conczin.gui;

import com.hypixel.hytale.assetstore.map.DefaultAssetMap;
import com.hypixel.hytale.codec.Codec;
import com.hypixel.hytale.component.Ref;
import com.hypixel.hytale.component.Store;
import com.hypixel.hytale.protocol.packets.interface_.CustomPageLifetime;
import com.hypixel.hytale.protocol.packets.interface_.CustomUIEventBindingType;
import com.hypixel.hytale.server.core.Message;
import com.hypixel.hytale.server.core.ui.Value;
import com.hypixel.hytale.server.core.ui.builder.EventData;
import com.hypixel.hytale.server.core.ui.builder.UICommandBuilder;
import com.hypixel.hytale.server.core.ui.builder.UIEventBuilder;
import com.hypixel.hytale.server.core.universe.PlayerRef;
import com.hypixel.hytale.server.core.universe.world.storage.EntityStore;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.conczin.data.Melody;
import net.conczin.data.MelodyAsset;
import net.conczin.data.MelodyProgress;
import net.conczin.data.YmmersiveMelodiesRegistry;
import net.conczin.gui.CodecDataInteractiveUIPage;
import net.conczin.gui.MelodyUploadGui;
import net.conczin.utils.RecordCodec;
import net.conczin.utils.Utils;

public class MelodySelectionGui
extends CodecDataInteractiveUIPage<Data> {
    private static final Value<String> BUTTON_LABEL_STYLE = Value.ref((String)"Pages/YmmersiveMelodies/MelodyButton.ui", (String)"LabelStyle");
    private static final Value<String> BUTTON_LABEL_STYLE_SELECTED = Value.ref((String)"Pages/YmmersiveMelodies/MelodyButton.ui", (String)"SelectedLabelStyle");
    private final String instrument;
    private String selectedMelody;
    private String searchQuery = "";

    public MelodySelectionGui(@Nonnull PlayerRef playerRef, String instrument) {
        this(playerRef, instrument, playerRef.getReference() == null ? "" : MelodySelectionGui.getMelody((Ref<EntityStore>)playerRef.getReference()));
    }

    public MelodySelectionGui(@Nonnull PlayerRef playerRef, String instrument, String initialMelody) {
        super(playerRef, CustomPageLifetime.CanDismiss, Data.CODEC);
        this.instrument = instrument;
        this.selectedMelody = initialMelody;
    }

    public void build(@Nonnull Ref<EntityStore> ref, @Nonnull UICommandBuilder commandBuilder, @Nonnull UIEventBuilder eventBuilder, @Nonnull Store<EntityStore> store) {
        commandBuilder.append("Pages/YmmersiveMelodies/MelodySelection.ui");
        eventBuilder.addEventBinding(CustomUIEventBindingType.ValueChanged, "#SearchInput", EventData.of((String)"@SearchQuery", (String)"#SearchInput.Value"), false);
        eventBuilder.addEventBinding(CustomUIEventBindingType.Activating, "#Stop", EventData.of((String)"Action", (String)"Stop"));
        eventBuilder.addEventBinding(CustomUIEventBindingType.Activating, "#Delete", EventData.of((String)"Action", (String)"Delete"));
        eventBuilder.addEventBinding(CustomUIEventBindingType.Activating, "#Upload", EventData.of((String)"Action", (String)"Upload"));
        this.buildList(ref, commandBuilder, eventBuilder);
    }

    private void buildList(Ref<EntityStore> ref, UICommandBuilder commandBuilder, UIEventBuilder eventBuilder) {
        commandBuilder.clear("#MelodyList");
        YmmersiveMelodiesRegistry resource = (YmmersiveMelodiesRegistry)ref.getStore().getResource(YmmersiveMelodiesRegistry.getResourceType());
        UUID uuid = Utils.getUUID(ref);
        Map<String, Melody> ownMelodies = resource.get(uuid);
        List<Melody> melodies = this.filterAndSort(ownMelodies);
        int rowIndex = 0;
        if (!melodies.isEmpty()) {
            MelodySelectionGui.addSeparator(commandBuilder, rowIndex, "customUI.melodySelection.separator.own");
            ++rowIndex;
        }
        for (Melody melody : melodies) {
            this.addMelody(commandBuilder, eventBuilder, rowIndex, String.valueOf(uuid) + ":" + melody.name(), melody.name());
            ++rowIndex;
        }
        if (!ownMelodies.isEmpty()) {
            MelodySelectionGui.addSeparator(commandBuilder, rowIndex, "customUI.melodySelection.separator.server");
            ++rowIndex;
        }
        for (MelodyAsset value : ((DefaultAssetMap)MelodyAsset.getAssetStore().getAssetMap()).getAssetMap().values()) {
            String name = value.getMelody().name();
            if (!this.searchQuery.isEmpty() && !value.getId().toLowerCase().contains(this.searchQuery) && !name.toLowerCase().contains(this.searchQuery)) continue;
            this.addMelody(commandBuilder, eventBuilder, rowIndex, value.getId(), name);
            ++rowIndex;
        }
        commandBuilder.set("#Stop.Disabled", this.selectedMelody.isEmpty());
        commandBuilder.set("#Delete.Disabled", this.selectedMelody.isEmpty() || !this.selectedMelody.startsWith(String.valueOf(uuid) + ":"));
    }

    private static void addSeparator(UICommandBuilder commandBuilder, int rowIndex, String message) {
        commandBuilder.append("#MelodyList", "Pages/YmmersiveMelodies/MelodySeperator.ui");
        commandBuilder.set("#MelodyList[" + rowIndex + "] #Label.Text", Message.translation((String)message));
    }

    private List<Melody> filterAndSort(Map<String, Melody> melodies) {
        return melodies.entrySet().stream().filter(e -> this.searchQuery.isEmpty() || ((Melody)e.getValue()).name().toLowerCase().contains(this.searchQuery) || ((String)e.getKey()).toLowerCase().contains(this.searchQuery)).sorted().map(Map.Entry::getValue).toList();
    }

    private void addMelody(UICommandBuilder commandBuilder, UIEventBuilder eventBuilder, int rowIndex, String identifier, String name) {
        commandBuilder.append("#MelodyList", "Pages/YmmersiveMelodies/MelodyButton.ui");
        commandBuilder.set("#MelodyList[" + rowIndex + "] #Button.Text", Message.translation((String)name));
        commandBuilder.set("#MelodyList[" + rowIndex + "] #Button.Style", identifier.equals(this.selectedMelody) ? BUTTON_LABEL_STYLE_SELECTED : BUTTON_LABEL_STYLE);
        eventBuilder.addEventBinding(CustomUIEventBindingType.Activating, "#MelodyList[" + rowIndex + "] #Button", EventData.of((String)"SelectedMelody", (String)identifier));
    }

    private void rebuildList(Ref<EntityStore> ref) {
        UICommandBuilder commandBuilder = new UICommandBuilder();
        UIEventBuilder eventBuilder = new UIEventBuilder();
        this.buildList(ref, commandBuilder, eventBuilder);
        this.sendUpdate(commandBuilder, eventBuilder, false);
    }

    @Override
    public void handleDataEvent(@Nonnull Ref<EntityStore> ref, @Nonnull Store<EntityStore> store, @Nonnull Data data) {
        super.handleDataEvent(ref, store, data);
        if (data.searchQuery != null) {
            this.searchQuery = data.searchQuery.trim().toLowerCase();
            this.rebuildList(ref);
        }
        if (data.selectedMelody != null) {
            this.setMelody(ref, data.selectedMelody);
            this.rebuildList(ref);
        }
        if ("Stop".equals(data.action)) {
            this.setMelody(ref, "");
            this.rebuildList(ref);
        }
        if ("Delete".equals(data.action)) {
            YmmersiveMelodiesRegistry resource = (YmmersiveMelodiesRegistry)store.getResource(YmmersiveMelodiesRegistry.getResourceType());
            String melodyName = this.selectedMelody.contains(":") ? this.selectedMelody.split(":", 2)[1] : this.selectedMelody;
            resource.delete(Utils.getUUID(ref), melodyName);
            this.setMelody(ref, "");
            this.rebuildList(ref);
        }
        if ("Tracks".equals(data.action)) {
            Utils.setPage(ref, store, MelodyUploadGui::new);
        }
        if ("Upload".equals(data.action)) {
            Utils.setPage(ref, store, MelodyUploadGui::new);
        }
    }

    private void setMelody(Ref<EntityStore> ref, String selectedMelody) {
        MelodyProgress progress = Utils.getData(ref, "MelodyProgress", MelodyProgress.CODEC);
        progress.melody = selectedMelody;
        progress.time = 0L;
        Utils.setData(ref, "MelodyProgress", MelodyProgress.CODEC, progress);
        this.selectedMelody = selectedMelody;
    }

    private static String getMelody(Ref<EntityStore> ref) {
        return Utils.getData(ref, (String)"MelodyProgress", MelodyProgress.CODEC).melody;
    }

    public record Data(String searchQuery, String selectedMelody, String action) {
        public static final Codec<Data> CODEC = RecordCodec.composite("@SearchQuery", Codec.STRING, Data::searchQuery, "SelectedMelody", Codec.STRING, Data::selectedMelody, "Action", Codec.STRING, Data::action, Data::new);
    }
}

