/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.cyclepaintings.event;

import com.hypixel.hytale.event.EventRegistry;
import com.hypixel.hytale.math.util.ChunkUtil;
import com.hypixel.hytale.math.vector.Vector3i;
import com.hypixel.hytale.server.core.asset.type.blocktype.config.BlockType;
import com.hypixel.hytale.server.core.entity.entities.Player;
import com.hypixel.hytale.server.core.event.events.BootEvent;
import com.hypixel.hytale.server.core.inventory.ItemStack;
import com.hypixel.hytale.server.core.universe.world.World;
import com.hypixel.hytale.server.core.universe.world.chunk.WorldChunk;
import com.natamus.cyclepaintings.config.ConfigHandler;
import com.natamus.cyclepaintings.data.Constants;
import com.natamus.cyclepaintings.util.Util;
import com.natamus.hybrid.data.HybridConstants;
import com.natamus.hybrid.event.callback.EntityBreakBlockCallback;
import java.util.ArrayList;

public class RegisterEvents {
    public static void init(EventRegistry eventRegistry) {
        eventRegistry.registerGlobal(BootEvent.class, RegisterEvents::onBootEvent);
        EntityBreakBlockCallback.ENTITY_BREAK_BLOCK.register(RegisterEvents::blockBreakEvent);
    }

    private static void onBootEvent(BootEvent e) {
        for (BlockType blockType : HybridConstants.BLOCKS.values()) {
            String paintingSize;
            String blockId = blockType.getId();
            String lowerBlockId = blockId.toLowerCase();
            if (!lowerBlockId.contains("painting") || lowerBlockId.contains("cyclepaintings") || (paintingSize = Util.getPaintingSize(blockType)) == null) continue;
            if (!Constants.PAINTINGS_BY_SIZE.containsKey(paintingSize)) {
                Constants.PAINTINGS_BY_SIZE.put(paintingSize, new ArrayList());
            }
            Constants.PAINTINGS_BY_SIZE.get(paintingSize).add(blockType);
        }
    }

    private static boolean blockBreakEvent(Player player, BlockType blockType, Vector3i targetBlockPos, ItemStack handStack) {
        if (!ConfigHandler.getConfigHandler().enableCyclePaintings) {
            return true;
        }
        if (!Util.isPaintingItem(handStack)) {
            return true;
        }
        if (!Util.isPaintingBlock(blockType)) {
            return true;
        }
        String paintingSize = Util.getPaintingSize(blockType);
        if (paintingSize == null) {
            return true;
        }
        World world = player.getWorld();
        if (world == null) {
            return true;
        }
        BlockType nextPainting = Util.getNextPainting(player, blockType, paintingSize);
        if (nextPainting == null) {
            return true;
        }
        WorldChunk worldChunk = world.getChunk(ChunkUtil.indexChunkFromBlock((int)targetBlockPos.x, (int)targetBlockPos.z));
        if (worldChunk == null) {
            return true;
        }
        int rotationIndex = worldChunk.getRotationIndex(targetBlockPos.x, targetBlockPos.y, targetBlockPos.z);
        int index = BlockType.getAssetMap().getIndex((Object)nextPainting.getId());
        int setBlockSetting = 4;
        if (ConfigHandler.getConfigHandler().showPaintingCycleParticles) {
            setBlockSetting = 0;
        }
        worldChunk.setBlock(targetBlockPos.x, targetBlockPos.y, targetBlockPos.z, index, nextPainting, rotationIndex, 0, setBlockSetting);
        return false;
    }
}

