/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.hybrid.functions;

import com.hypixel.hytale.component.ComponentAccessor;
import com.hypixel.hytale.component.Ref;
import com.hypixel.hytale.protocol.GameMode;
import com.hypixel.hytale.server.core.entity.entities.Player;
import com.hypixel.hytale.server.core.entity.movement.MovementStatesComponent;
import com.hypixel.hytale.server.core.inventory.Inventory;
import com.hypixel.hytale.server.core.inventory.ItemStack;
import com.hypixel.hytale.server.core.universe.world.World;

public class PlayerFunctions {
    public static boolean isCrouching(Player player) {
        World world = player.getWorld();
        if (world == null) {
            return false;
        }
        Ref playerReference = player.getReference();
        if (playerReference == null) {
            return false;
        }
        MovementStatesComponent movementStatesComponent = (MovementStatesComponent)world.getEntityStore().getStore().getComponent(playerReference, MovementStatesComponent.getComponentType());
        if (movementStatesComponent == null) {
            return false;
        }
        return movementStatesComponent.getMovementStates().crouching;
    }

    public static boolean isJoiningTheWorldForTheFirstTime(Player player) {
        return player.isFirstSpawn();
    }

    public static void decreaseHeldItemDurability(Player player, double amount, boolean ignoreGamemode) {
        World world = player.getWorld();
        if (world == null) {
            return;
        }
        PlayerFunctions.decreaseHeldItemDurability(player, world, amount, ignoreGamemode);
    }

    public static void decreaseHeldItemDurability(Player player, World world, double amount, boolean ignoreGamemode) {
        Ref playerRef = player.getReference();
        if (playerRef == null) {
            return;
        }
        if (!ignoreGamemode && player.getGameMode().equals((Object)GameMode.Creative)) {
            return;
        }
        Inventory playerInventory = player.getInventory();
        ItemStack handStack = playerInventory.getItemInHand();
        if (handStack == null) {
            return;
        }
        player.updateItemStackDurability(playerRef, handStack, playerInventory.getHotbar(), (int)playerInventory.getActiveHotbarSlot(), -amount, (ComponentAccessor)world.getEntityStore().getStore());
    }
}

