/*
 * Decompiled with CFR 0.152.
 */
package net.conczin;

import com.hypixel.hytale.codec.builder.BuilderCodec;
import com.hypixel.hytale.component.CommandBuffer;
import com.hypixel.hytale.component.ComponentAccessor;
import com.hypixel.hytale.component.Ref;
import com.hypixel.hytale.component.Store;
import com.hypixel.hytale.math.vector.Vector3i;
import com.hypixel.hytale.protocol.InteractionType;
import com.hypixel.hytale.server.core.Message;
import com.hypixel.hytale.server.core.asset.type.soundevent.config.SoundEvent;
import com.hypixel.hytale.server.core.entity.InteractionContext;
import com.hypixel.hytale.server.core.entity.entities.Player;
import com.hypixel.hytale.server.core.inventory.ItemStack;
import com.hypixel.hytale.server.core.inventory.container.ItemContainer;
import com.hypixel.hytale.server.core.inventory.container.SimpleItemContainer;
import com.hypixel.hytale.server.core.modules.interaction.interaction.CooldownHandler;
import com.hypixel.hytale.server.core.modules.interaction.interaction.config.client.SimpleBlockInteraction;
import com.hypixel.hytale.server.core.universe.world.SoundUtil;
import com.hypixel.hytale.server.core.universe.world.World;
import com.hypixel.hytale.server.core.universe.world.storage.EntityStore;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.conczin.data.BookData;
import net.conczin.data.MailboxResource;
import net.conczin.gui.MailComposeGui;
import net.conczin.utils.Utils;

public class MailboxInteraction
extends SimpleBlockInteraction {
    public static final BuilderCodec<MailboxInteraction> CODEC = ((BuilderCodec.Builder)BuilderCodec.builder(MailboxInteraction.class, MailboxInteraction::new, (BuilderCodec)SimpleBlockInteraction.CODEC).documentation("Retrieves or sends mail.")).build();

    protected void interactWithBlock(@Nonnull World world, @Nonnull CommandBuffer<EntityStore> commandBuffer, @Nonnull InteractionType type, @Nonnull InteractionContext context, @Nullable ItemStack itemInHand, @Nonnull Vector3i targetBlock, @Nonnull CooldownHandler cooldownHandler) {
        BookData book;
        Ref ref = context.getEntity();
        Store store = ref.getStore();
        UUID uuid = Utils.getUUID((Ref<EntityStore>)ref);
        Player player = (Player)store.getComponent(ref, Player.getComponentType());
        if (player == null) {
            return;
        }
        BookData bookData = book = itemInHand != null ? (BookData)itemInHand.getFromMetadataOrNull("BookAndPapers_BookData", BookData.CODEC) : null;
        if (book != null) {
            Utils.setPage((Ref<EntityStore>)ref, (Store<EntityStore>)store, MailComposeGui::new);
            MailboxInteraction.playSound(commandBuffer, targetBlock, (Ref<EntityStore>)ref, "SFX_Books_And_Papers_Mailbox_Send");
        } else {
            MailboxResource mailboxResource = (MailboxResource)store.getResource(MailboxResource.getResourceType());
            MailboxResource.MailBox mailbox = mailboxResource.getMailbox(uuid);
            mailbox.setPlayerName(player.getDisplayName());
            if (mailbox.hasMail()) {
                ItemStack pop = mailbox.pop();
                if (pop != null) {
                    SimpleItemContainer.addOrDropItemStacks((ComponentAccessor)store, (Ref)ref, (ItemContainer)player.getInventory().getCombinedHotbarFirst(), List.of(pop));
                    MailboxInteraction.playSound(commandBuffer, targetBlock, (Ref<EntityStore>)ref, "SFX_Books_And_Papers_Mailbox_Receive");
                }
            } else {
                player.sendMessage(Message.translation((String)"server.interactions.booksAndPapers.mailbox.empty"));
                MailboxInteraction.playSound(commandBuffer, targetBlock, (Ref<EntityStore>)ref, "SFX_Books_And_Papers_Mailbox_Empty");
            }
        }
    }

    private static void playSound(CommandBuffer<EntityStore> commandBuffer, Vector3i targetBlock, Ref<EntityStore> ref, String sound) {
        int soundEventIndex = SoundEvent.getAssetMap().getIndex((Object)sound);
        SoundUtil.playSoundEvent3d(ref, (int)soundEventIndex, (double)targetBlock.x, (double)targetBlock.y, (double)targetBlock.z, commandBuffer);
    }

    protected void simulateInteractWithBlock(@Nonnull InteractionType type, @Nonnull InteractionContext context, @Nullable ItemStack itemInHand, @Nonnull World world, @Nonnull Vector3i targetBlock) {
    }
}

