/*
 * Decompiled with CFR 0.152.
 */
package net.conczin.data;

import com.hypixel.hytale.codec.Codec;
import com.hypixel.hytale.codec.KeyedCodec;
import com.hypixel.hytale.codec.builder.BuilderCodec;
import com.hypixel.hytale.codec.codecs.map.MapCodec;
import com.hypixel.hytale.component.Resource;
import com.hypixel.hytale.component.ResourceType;
import com.hypixel.hytale.server.core.inventory.ItemStack;
import com.hypixel.hytale.server.core.universe.world.storage.EntityStore;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import net.conczin.BooksAndPapers;
import net.conczin.utils.ListCodec;

public class MailboxResource
implements Resource<EntityStore> {
    public static final BuilderCodec<MailboxResource> CODEC = ((BuilderCodec.Builder)BuilderCodec.builder(MailboxResource.class, MailboxResource::new).append(new KeyedCodec("Mailboxes", (Codec)new MapCodec(MailBox.CODEC, HashMap::new), true), (o, map) -> {
        if (map != null) {
            map.forEach((k, v) -> o.mailboxes.put(UUID.fromString(k), new MailBox((MailBox)v)));
        }
    }, o -> {
        HashMap out = new HashMap();
        o.mailboxes.forEach((uuid, mailbox) -> out.put(uuid.toString(), mailbox));
        return out;
    }).add()).build();
    private final Map<UUID, MailBox> mailboxes = new HashMap<UUID, MailBox>();

    public static ResourceType<EntityStore, MailboxResource> getResourceType() {
        return BooksAndPapers.getInstance().getMailbox();
    }

    public MailboxResource() {
    }

    public MailboxResource(MailboxResource other) {
        other.mailboxes.forEach((k, v) -> this.mailboxes.put((UUID)k, new MailBox((MailBox)v)));
    }

    public void push(UUID playerUuid, ItemStack item) {
        this.mailboxes.computeIfAbsent(playerUuid, uUID -> new MailBox()).push(item);
    }

    public MailBox getMailbox(UUID playerUuid) {
        return this.mailboxes.computeIfAbsent(playerUuid, uUID -> new MailBox());
    }

    public Map<UUID, MailBox> getMailboxes() {
        return this.mailboxes;
    }

    @Nullable
    public Resource<EntityStore> clone() {
        return new MailboxResource(this);
    }

    public static class MailBox {
        private final List<ItemStack> mails;
        private String playerName;
        public static final BuilderCodec<MailBox> CODEC = ((BuilderCodec.Builder)((BuilderCodec.Builder)BuilderCodec.builder(MailBox.class, MailBox::new).append(new KeyedCodec("Mails", new ListCodec(ItemStack.CODEC), true), (o, list) -> {
            if (list != null) {
                o.mails.addAll((Collection<ItemStack>)list);
            }
        }, o -> o.mails).add()).append(new KeyedCodec("PlayerName", (Codec)Codec.STRING, false), (o, name) -> {
            o.playerName = name;
        }, o -> o.playerName).add()).build();

        public MailBox() {
            this.mails = new LinkedList<ItemStack>();
            this.playerName = "";
        }

        public MailBox(MailBox other) {
            this.mails = new LinkedList<ItemStack>(other.mails);
            this.playerName = other.playerName;
        }

        public void push(ItemStack item) {
            this.mails.add(item);
        }

        public ItemStack pop() {
            if (this.mails.isEmpty()) {
                return null;
            }
            return this.mails.removeFirst();
        }

        public boolean hasMail() {
            return !this.mails.isEmpty();
        }

        public String getPlayerName() {
            return this.playerName;
        }

        public void setPlayerName(String playerName) {
            this.playerName = playerName;
        }
    }
}

