/*
 * Decompiled with CFR 0.152.
 */
package net.conczin.gui;

import com.hypixel.hytale.codec.Codec;
import com.hypixel.hytale.component.Ref;
import com.hypixel.hytale.component.Store;
import com.hypixel.hytale.protocol.packets.interface_.CustomPageLifetime;
import com.hypixel.hytale.protocol.packets.interface_.CustomUIEventBindingType;
import com.hypixel.hytale.server.core.entity.entities.Player;
import com.hypixel.hytale.server.core.ui.builder.EventData;
import com.hypixel.hytale.server.core.ui.builder.UICommandBuilder;
import com.hypixel.hytale.server.core.ui.builder.UIEventBuilder;
import com.hypixel.hytale.server.core.universe.PlayerRef;
import com.hypixel.hytale.server.core.universe.world.storage.EntityStore;
import java.util.Objects;
import javax.annotation.Nonnull;
import net.conczin.data.BookData;
import net.conczin.gui.CodecDataInteractiveUIPage;
import net.conczin.utils.RecordCodec;
import net.conczin.utils.Utils;

public class BookSignGui
extends CodecDataInteractiveUIPage<Data> {
    public BookSignGui(@Nonnull PlayerRef playerRef, @Nonnull CustomPageLifetime lifetime) {
        super(playerRef, lifetime, Data.CODEC);
    }

    public void build(@Nonnull Ref<EntityStore> ref, @Nonnull UICommandBuilder commandBuilder, @Nonnull UIEventBuilder eventBuilder, @Nonnull Store<EntityStore> store) {
        commandBuilder.append("Pages/BooksAndPapers/BookSign.ui");
        String author = Objects.requireNonNull((Player)ref.getStore().getComponent(ref, Player.getComponentType())).getDisplayName();
        commandBuilder.set("#TitleField.Value", "");
        commandBuilder.set("#Author.Value", author);
        eventBuilder.addEventBinding(CustomUIEventBindingType.Activating, "#Sign", new EventData().append("Action", "Sign").append("@Title", "#TitleField.Value").append("@Author", "#Author.Value"));
        eventBuilder.addEventBinding(CustomUIEventBindingType.Activating, "#Cancel", EventData.of((String)"Action", (String)"Cancel"));
    }

    @Override
    public void handleDataEvent(@Nonnull Ref<EntityStore> ref, @Nonnull Store<EntityStore> store, @Nonnull Data data) {
        super.handleDataEvent(ref, store, data);
        if ("Sign".equals(data.action)) {
            this.sign(ref, data.title, data.author);
            this.close();
        }
        if ("Cancel".equals(data.action)) {
            this.close();
        }
    }

    private void sign(Ref<EntityStore> ref, String title, String author) {
        BookData book = Utils.getData(ref, "BookAndPapers_BookData", BookData.CODEC);
        if (book.signed) {
            return;
        }
        book.author = author;
        book.title = title;
        book.signed = true;
        book.trim();
        Utils.setData(ref, "BookAndPapers_BookData", BookData.CODEC, book);
    }

    public record Data(String title, String author, String action) {
        public static final Codec<Data> CODEC = RecordCodec.composite("@Title", Codec.STRING, Data::title, "@Author", Codec.STRING, Data::author, "Action", Codec.STRING, Data::action, Data::new);
    }
}

