/*
 * Decompiled with CFR 0.152.
 */
package net.conczin;

import com.hypixel.hytale.server.core.Message;
import java.util.LinkedList;

public class Parser {
    public static Message parse(String input) {
        String color = null;
        boolean bold = false;
        boolean italic = false;
        boolean monospace = false;
        LinkedList<Message> messages = new LinkedList<Message>();
        int i = 0;
        int n = input.length();
        int last = 0;
        while (i < n) {
            char c = input.charAt(i);
            if (c == '<') {
                int end;
                if (i > last) {
                    String chunk = input.substring(last, i);
                    messages.add(Parser.getMessage(chunk, color, bold, italic, monospace));
                }
                if ((end = input.indexOf(62, i)) < 0) break;
                String tag = input.substring(i + 1, end);
                last = i = end + 1;
                boolean closing = tag.startsWith("/");
                if (closing) {
                    tag = tag.substring(1);
                }
                if (tag.equals("b")) {
                    bold = !closing;
                    continue;
                }
                if (tag.equals("i")) {
                    italic = !closing;
                    continue;
                }
                if (tag.equals("m")) {
                    monospace = !closing;
                    continue;
                }
                if (!tag.startsWith("color")) continue;
                if (!closing) {
                    int q;
                    int p = tag.indexOf("is=\"");
                    if (p == -1 || (q = tag.indexOf(34, p + 4)) == -1) continue;
                    color = tag.substring(p + 4, q);
                    continue;
                }
                color = null;
                continue;
            }
            ++i;
        }
        if (i > last) {
            String chunk = input.substring(last, i);
            messages.add(Parser.getMessage(chunk, color, bold, italic, monospace));
        }
        return Message.join((Message[])messages.toArray(new Message[0]));
    }

    private static Message getMessage(String chunk, String color, boolean bold, boolean italic, boolean monospace) {
        Message m = Message.raw((String)chunk);
        if (color != null) {
            m = m.color(color);
        }
        if (bold) {
            m = m.bold(true);
        }
        if (italic) {
            m = m.italic(true);
        }
        if (monospace) {
            m = m.monospace(true);
        }
        return m;
    }
}

