/*
 * Decompiled with CFR 0.152.
 */
package net.conczin.data;

import com.hypixel.hytale.codec.Codec;
import com.hypixel.hytale.codec.KeyedCodec;
import com.hypixel.hytale.codec.builder.BuilderCodec;
import java.util.LinkedList;
import java.util.List;
import net.conczin.utils.ListCodec;

public final class BookData {
    public static final String METADATA_KEY = "BookAndPapers_BookData";
    public static final BuilderCodec<BookData> CODEC = ((BuilderCodec.Builder)((BuilderCodec.Builder)((BuilderCodec.Builder)((BuilderCodec.Builder)BuilderCodec.builder(BookData.class, BookData::new).appendInherited(new KeyedCodec("Title", (Codec)Codec.STRING), (o, v) -> {
        o.title = v;
    }, o -> o.title, (o, p) -> {
        o.title = p.title;
    }).add()).appendInherited(new KeyedCodec("Pages", new ListCodec<Page>((Codec<Page>)Page.CODEC)), (o, v) -> {
        o.pages = v;
    }, o -> o.pages, (o, p) -> {
        o.pages = p.pages;
    }).add()).appendInherited(new KeyedCodec("Author", (Codec)Codec.STRING), (o, v) -> {
        o.author = v;
    }, o -> o.author, (o, p) -> {
        o.author = p.author;
    }).add()).appendInherited(new KeyedCodec("Signed", (Codec)Codec.BOOLEAN), (o, v) -> {
        o.signed = v;
    }, o -> o.signed, (o, p) -> {
        o.signed = p.signed;
    }).add()).build();
    public String title = "";
    public List<Page> pages = new LinkedList<Page>();
    public String author = "";
    public boolean signed = false;

    public Page getOrCreatePage(int page) {
        page = Math.max(0, page);
        while (this.pages.size() <= page) {
            this.pages.add(new Page());
        }
        return this.pages.get(page);
    }

    public void trim() {
        while (!this.pages.isEmpty() && this.pages.getFirst().content.isEmpty() && this.pages.getFirst().title.isEmpty()) {
            this.pages.removeFirst();
        }
        if (this.pages.isEmpty()) {
            this.pages.add(new Page());
        }
    }

    public static final class Page {
        public static final BuilderCodec<Page> CODEC = ((BuilderCodec.Builder)((BuilderCodec.Builder)BuilderCodec.builder(Page.class, Page::new).appendInherited(new KeyedCodec("Title", (Codec)Codec.STRING), (o, v) -> {
            o.title = v;
        }, o -> o.title, (o, p) -> {
            o.title = p.title;
        }).add()).appendInherited(new KeyedCodec("Content", (Codec)Codec.STRING), (o, v) -> {
            o.content = v;
        }, o -> o.content, (o, p) -> {
            o.content = p.content;
        }).add()).build();
        public String title = "";
        public String content = "";
    }
}

