/*
 * Decompiled with CFR 0.152.
 */
package net.conczin.gui;

import com.hypixel.hytale.codec.Codec;
import com.hypixel.hytale.component.Ref;
import com.hypixel.hytale.component.Store;
import com.hypixel.hytale.protocol.packets.interface_.CustomPageLifetime;
import com.hypixel.hytale.protocol.packets.interface_.CustomUIEventBindingType;
import com.hypixel.hytale.server.core.ui.builder.EventData;
import com.hypixel.hytale.server.core.ui.builder.UICommandBuilder;
import com.hypixel.hytale.server.core.ui.builder.UIEventBuilder;
import com.hypixel.hytale.server.core.universe.PlayerRef;
import com.hypixel.hytale.server.core.universe.world.storage.EntityStore;
import javax.annotation.Nonnull;
import net.conczin.Parser;
import net.conczin.data.BookData;
import net.conczin.gui.BookSignGui;
import net.conczin.gui.CodecDataInteractiveUIPage;
import net.conczin.utils.RecordCodec;
import net.conczin.utils.Utils;

public class BooksGui
extends CodecDataInteractiveUIPage<Data> {
    private boolean editMode = true;
    private int page = 0;
    private final String style;
    private final String background;

    public BooksGui(@Nonnull PlayerRef playerRef, String style, String background) {
        super(playerRef, CustomPageLifetime.CanDismiss, Data.CODEC);
        this.style = style;
        this.background = background;
    }

    public void build(@Nonnull Ref<EntityStore> ref, @Nonnull UICommandBuilder commandBuilder, @Nonnull UIEventBuilder eventBuilder, @Nonnull Store<EntityStore> store) {
        commandBuilder.append("Pages/BooksAndPapers/Styles/" + this.style + ".ui");
        eventBuilder.addEventBinding(CustomUIEventBindingType.ValueChanged, "#Title", EventData.of((String)"@Title", (String)"#Title.Value"), false);
        eventBuilder.addEventBinding(CustomUIEventBindingType.ValueChanged, "#Content", EventData.of((String)"@Content", (String)"#Content.Value"), false);
        eventBuilder.addEventBinding(CustomUIEventBindingType.Activating, "#Previous", EventData.of((String)"Action", (String)"Previous"));
        eventBuilder.addEventBinding(CustomUIEventBindingType.Activating, "#Next", EventData.of((String)"Action", (String)"Next"));
        eventBuilder.addEventBinding(CustomUIEventBindingType.Activating, "#Sign", EventData.of((String)"Action", (String)"Sign"));
        eventBuilder.addEventBinding(CustomUIEventBindingType.Activating, "#Edit", EventData.of((String)"Action", (String)"Edit"));
        this.buildList(ref, commandBuilder);
    }

    private void buildList(Ref<EntityStore> ref, UICommandBuilder commandBuilder) {
        BookData book = Utils.getData(ref, "BookAndPapers_BookData", BookData.CODEC);
        boolean bl = this.editMode = this.editMode && !book.signed;
        if (!this.editMode) {
            this.page = Math.min(this.page, book.pages.size() - 1);
        }
        commandBuilder.set("#Background.Background", "Common/" + this.background + ".png");
        BookData.Page page = book.getOrCreatePage(this.page);
        if (this.editMode) {
            commandBuilder.set("#Title.Value", page.title);
            commandBuilder.set("#Content.Value", page.content);
        } else {
            commandBuilder.set("#TitleLabel.TextSpans", Parser.parse(page.title));
            commandBuilder.set("#ContentLabel.TextSpans", Parser.parse(page.content));
        }
        commandBuilder.set("#Title.Visible", this.editMode);
        commandBuilder.set("#TitleLabel.Visible", !this.editMode);
        commandBuilder.set("#Content.Visible", this.editMode);
        commandBuilder.set("#ContentLabel.Visible", !this.editMode);
        commandBuilder.set("#PageNumber.Text", String.format("%d/%d", this.page + 1, book.pages.size()));
        commandBuilder.set("#Edit.Visible", !book.signed);
        commandBuilder.set("#Sign.Visible", !book.signed);
    }

    private void rebuildPage(Ref<EntityStore> ref) {
        UICommandBuilder commandBuilder = new UICommandBuilder();
        UIEventBuilder eventBuilder = new UIEventBuilder();
        this.buildList(ref, commandBuilder);
        this.sendUpdate(commandBuilder, eventBuilder, false);
    }

    @Override
    public void handleDataEvent(@Nonnull Ref<EntityStore> ref, @Nonnull Store<EntityStore> store, @Nonnull Data data) {
        super.handleDataEvent(ref, store, data);
        if (data.title != null || data.content != null) {
            this.saveBook(ref, data.title, data.content);
        }
        if ("Previous".equals(data.action)) {
            this.page = Math.max(0, this.page - 1);
            this.rebuildPage(ref);
        }
        if ("Next".equals(data.action)) {
            ++this.page;
            this.rebuildPage(ref);
        }
        if ("Edit".equals(data.action)) {
            this.editMode = !this.editMode;
            this.rebuildPage(ref);
        }
        if ("Sign".equals(data.action)) {
            Utils.setPage(ref, store, BookSignGui::new);
        }
    }

    private void saveBook(Ref<EntityStore> ref, String title, String content) {
        BookData book = Utils.getData(ref, "BookAndPapers_BookData", BookData.CODEC);
        if (book.signed) {
            return;
        }
        BookData.Page page = book.getOrCreatePage(this.page);
        page.title = title == null ? page.title : title;
        page.content = content == null ? page.content : content;
        Utils.setData(ref, "BookAndPapers_BookData", BookData.CODEC, book);
    }

    public record Data(String title, String content, String action) {
        public static final Codec<Data> CODEC = RecordCodec.composite("@Title", Codec.STRING, Data::title, "@Content", Codec.STRING, Data::content, "Action", Codec.STRING, Data::action, Data::new);
    }
}

