/*
 * Decompiled with CFR 0.152.
 */
package net.conczin.utils;

import com.hypixel.hytale.codec.Codec;
import com.hypixel.hytale.codec.ExtraInfo;
import com.hypixel.hytale.codec.RawJsonCodec;
import com.hypixel.hytale.codec.WrappedCodec;
import com.hypixel.hytale.codec.schema.SchemaContext;
import com.hypixel.hytale.codec.schema.config.ArraySchema;
import com.hypixel.hytale.codec.schema.config.Schema;
import com.hypixel.hytale.codec.util.RawJsonReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import org.bson.BsonArray;
import org.bson.BsonNull;
import org.bson.BsonValue;

public class ListCodec<T>
implements Codec<List<T>>,
RawJsonCodec<List<T>>,
WrappedCodec<T> {
    private final Codec<T> codec;

    public ListCodec(Codec<T> codec) {
        this.codec = codec;
    }

    public Codec<T> getChildCodec() {
        return this.codec;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<T> decode(BsonValue value, ExtraInfo info) {
        BsonArray arr = value.asArray();
        ArrayList<Object> out = new ArrayList<Object>(arr.size());
        for (int i = 0; i < arr.size(); ++i) {
            info.pushIntKey(i);
            try {
                out.add(arr.get(i).isNull() ? null : this.codec.decode(arr.get(i), info));
                continue;
            }
            finally {
                info.popKey();
            }
        }
        return out;
    }

    public BsonValue encode(List<T> list, ExtraInfo info) {
        BsonArray arr = new BsonArray();
        for (T v : list) {
            arr.add((BsonValue)(v == null ? new BsonNull() : this.codec.encode(v, info)));
        }
        return arr;
    }

    public List<T> decodeJson(RawJsonReader reader, ExtraInfo extraInfo) throws IOException {
        BsonValue bsonvalue = RawJsonReader.readBsonValue((RawJsonReader)reader);
        return this.decode(bsonvalue, extraInfo);
    }

    @Nonnull
    public Schema toSchema(SchemaContext ctx) {
        ArraySchema s = new ArraySchema();
        s.setItem(ctx.refDefinition(this.codec));
        return s;
    }
}

