/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.cyclepaintings.util;

import com.hypixel.hytale.server.core.asset.type.blocktype.config.BlockType;
import com.hypixel.hytale.server.core.asset.type.blocktype.config.CustomModelTexture;
import com.hypixel.hytale.server.core.entity.entities.Player;
import com.hypixel.hytale.server.core.inventory.ItemStack;
import com.natamus.cyclepaintings.data.Constants;
import com.natamus.hybrid.functions.PlayerFunctions;
import java.util.List;
import javax.annotation.Nullable;

public class Util {
    public static boolean isPaintingBlock(BlockType blockType) {
        return blockType.getId().toLowerCase().contains("painting");
    }

    public static boolean isPaintingItem(@Nullable ItemStack itemStack) {
        if (itemStack == null) {
            return false;
        }
        return itemStack.getItemId().toLowerCase().contains("painting");
    }

    @Nullable
    public static String getPaintingSize(BlockType blockType) {
        CustomModelTexture[] customModelTextures = blockType.getCustomModelTexture();
        if (customModelTextures == null) {
            return null;
        }
        for (CustomModelTexture customModelTexture : customModelTextures) {
            String size;
            int start;
            int end;
            if (customModelTexture == null) continue;
            String path = customModelTexture.getTexture();
            int paintingsIdx = path.indexOf("Paintings/");
            if (paintingsIdx != -1 && (end = path.indexOf(47, start = paintingsIdx + "Paintings/".length())) != -1 && (size = path.substring(start, end)).length() == 3 && size.charAt(1) == 'x') {
                return size;
            }
            for (int i = 0; i < path.length() - 2; ++i) {
                if (path.charAt(i + 1) != 'x') continue;
                char w = path.charAt(i);
                char h = path.charAt(i + 2);
                if (!Character.isDigit(w) || !Character.isDigit(h)) continue;
                return w + "x" + h;
            }
        }
        return null;
    }

    public static BlockType getNextPainting(Player player, BlockType currentPainting, String paintingSize) {
        List<BlockType> paintings = Constants.PAINTINGS_BY_SIZE.get(paintingSize);
        if (paintings == null || paintings.isEmpty()) {
            return currentPainting;
        }
        int currentIndex = -1;
        String currentId = currentPainting.getId();
        for (int i = 0; i < paintings.size(); ++i) {
            if (!paintings.get(i).getId().equals(currentId)) continue;
            currentIndex = i;
            break;
        }
        if (currentIndex == -1) {
            return paintings.getFirst();
        }
        int offset = PlayerFunctions.isCrouching((Player)player) ? -1 : 1;
        int nextIndex = Math.floorMod(currentIndex + offset, paintings.size());
        return paintings.get(nextIndex);
    }
}

