/*
 * Decompiled with CFR 0.152.
 */
package net.conczin.data;

import com.hypixel.hytale.assetstore.AssetExtraInfo;
import com.hypixel.hytale.assetstore.AssetRegistry;
import com.hypixel.hytale.assetstore.AssetStore;
import com.hypixel.hytale.assetstore.codec.AssetBuilderCodec;
import com.hypixel.hytale.assetstore.map.DefaultAssetMap;
import com.hypixel.hytale.assetstore.map.JsonAssetWithMap;
import com.hypixel.hytale.codec.Codec;
import com.hypixel.hytale.codec.KeyedCodec;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import net.conczin.data.Melody;
import net.conczin.data.MidiParser;

public class MelodyAsset
implements JsonAssetWithMap<String, DefaultAssetMap<String, MelodyAsset>> {
    public static final AssetBuilderCodec<String, MelodyAsset> CODEC = ((AssetBuilderCodec.Builder)((AssetBuilderCodec.Builder)AssetBuilderCodec.builder(MelodyAsset.class, MelodyAsset::new, (Codec)Codec.STRING, (t, id) -> {
        t.id = id;
    }, t -> t.id, (t, data) -> {
        t.data = data;
    }, t -> t.data).appendInherited(new KeyedCodec("Name", (Codec)Codec.STRING), (item, v) -> {
        item.name = v;
    }, item -> item.name, (item, parent) -> {
        item.name = parent.name;
    }).add()).afterDecode((o, extrainfo) -> {
        if (o.id != null && extrainfo instanceof AssetExtraInfo) {
            AssetExtraInfo assetExtraInfo = (AssetExtraInfo)extrainfo;
            Path path = assetExtraInfo.getAssetPath();
            if (path == null) {
                return;
            }
            Path midiPath = path.getParent().resolve(path.getFileName().toString().replaceFirst("\\.json$", ".midi"));
            try (InputStream midiStream = Files.newInputStream(midiPath, new OpenOption[0]);){
                o.melody = new Melody(o.name, MidiParser.parseMidi(midiStream));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    })).build();
    private static AssetStore<String, MelodyAsset, DefaultAssetMap<String, MelodyAsset>> ASSET_STORE;
    private String id;
    private AssetExtraInfo.Data data;
    private String name;
    private Melody melody;

    public static AssetStore<String, MelodyAsset, DefaultAssetMap<String, MelodyAsset>> getAssetStore() {
        if (ASSET_STORE == null) {
            ASSET_STORE = AssetRegistry.getAssetStore(MelodyAsset.class);
        }
        return ASSET_STORE;
    }

    public String getId() {
        return this.id;
    }

    public Melody getMelody() {
        return this.melody;
    }
}

