/*
 * Decompiled with CFR 0.152.
 */
package net.conczin.data;

import com.hypixel.hytale.assetstore.map.DefaultAssetMap;
import com.hypixel.hytale.codec.Codec;
import com.hypixel.hytale.codec.KeyedCodec;
import com.hypixel.hytale.codec.builder.BuilderCodec;
import com.hypixel.hytale.component.ComponentAccessor;
import com.hypixel.hytale.component.Ref;
import com.hypixel.hytale.component.Store;
import com.hypixel.hytale.component.spatial.SpatialResource;
import com.hypixel.hytale.math.vector.Vector3d;
import com.hypixel.hytale.protocol.InteractionType;
import com.hypixel.hytale.protocol.Packet;
import com.hypixel.hytale.protocol.Position;
import com.hypixel.hytale.protocol.SoundCategory;
import com.hypixel.hytale.protocol.packets.world.PlaySoundEvent3D;
import com.hypixel.hytale.server.core.asset.type.soundevent.config.SoundEvent;
import com.hypixel.hytale.server.core.entity.InteractionContext;
import com.hypixel.hytale.server.core.inventory.ItemStack;
import com.hypixel.hytale.server.core.inventory.container.ItemContainer;
import com.hypixel.hytale.server.core.modules.entity.EntityModule;
import com.hypixel.hytale.server.core.modules.entity.component.TransformComponent;
import com.hypixel.hytale.server.core.modules.interaction.interaction.CooldownHandler;
import com.hypixel.hytale.server.core.modules.interaction.interaction.config.SimpleInteraction;
import com.hypixel.hytale.server.core.modules.time.TimeResource;
import com.hypixel.hytale.server.core.universe.PlayerRef;
import com.hypixel.hytale.server.core.universe.world.storage.EntityStore;
import it.unimi.dsi.fastutil.objects.ObjectList;
import java.time.Instant;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import net.conczin.data.Melody;
import net.conczin.data.MelodyAsset;
import net.conczin.data.MelodyProgress;
import net.conczin.data.YmmersiveMelodiesRegistry;
import net.conczin.utils.Utils;

public class MelodyPlaybackInteraction
extends SimpleInteraction {
    public static final BuilderCodec<MelodyPlaybackInteraction> CODEC = ((BuilderCodec.Builder)((BuilderCodec.Builder)BuilderCodec.builder(MelodyPlaybackInteraction.class, MelodyPlaybackInteraction::new, (BuilderCodec)SimpleInteraction.CODEC).documentation("Plays back a melody.")).appendInherited(new KeyedCodec("Instrument", (Codec)Codec.STRING), (o, v) -> {
        o.instrument = v;
    }, o -> o.instrument, (o, p) -> {
        o.instrument = p.instrument;
    }).add()).build();
    private static final ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor();
    private static final int[] LENGTHS = new int[]{125, 250, 375, 500, 625, 750, 875, 1000, 1250, 1500, 1750, 2000, 2500, 3000, 4000};
    private String instrument;

    private int findClosestLength(int length) {
        int closest = LENGTHS[0];
        for (int l : LENGTHS) {
            if (Math.abs(length - l) >= Math.abs(length - closest)) continue;
            closest = l;
        }
        return closest;
    }

    protected void tick0(boolean firstRun, float time, InteractionType type, @Nonnull InteractionContext context, CooldownHandler cooldownHandler) {
        Melody melody;
        Ref ref = context.getEntity();
        if (!ref.isValid()) {
            return;
        }
        Store store = ref.getStore();
        TransformComponent component = (TransformComponent)store.getComponent(ref, TransformComponent.getComponentType());
        if (component == null) {
            return;
        }
        Vector3d position = component.getPosition();
        ItemStack itemInHand = context.getHeldItem();
        if (itemInHand == null) {
            return;
        }
        MelodyProgress progress = (MelodyProgress)itemInHand.getFromMetadataOrDefault("MelodyProgress", MelodyProgress.CODEC);
        if (progress.melody.isEmpty()) {
            return;
        }
        long buffer = 150L;
        Instant timeResource = ((TimeResource)store.getResource(TimeResource.getResourceType())).getNow();
        long timeMs = timeResource.getEpochSecond() * 1000L + (long)timeResource.getNano() / 1000000L;
        long delta = Math.min(timeMs - progress.worldTime, buffer);
        if (delta <= 0L) {
            return;
        }
        if (progress.melody.contains(":")) {
            YmmersiveMelodiesRegistry resource = (YmmersiveMelodiesRegistry)store.getResource(YmmersiveMelodiesRegistry.getResourceType());
            melody = resource.get(Utils.getUUID((Ref<EntityStore>)ref), progress.melody.split(":", 2)[1]);
        } else {
            MelodyAsset asset = (MelodyAsset)((DefaultAssetMap)MelodyAsset.getAssetStore().getAssetMap()).getAsset((Object)progress.melody);
            if (asset == null) {
                return;
            }
            melody = asset.getMelody();
        }
        for (Melody.Track track : melody.tracks()) {
            for (Melody.Note note : track.notes()) {
                int octave;
                long delay;
                if ((long)note.time() < progress.time || (long)note.time() >= progress.time + delta || (delay = (long)note.time() - (progress.time + delta) + buffer) <= 0L) continue;
                float volume = (float)note.velocity() / 64.0f;
                float pitch = (float)Math.pow(2.0, (double)(note.note() - 24) / 12.0);
                for (octave = 1; octave < 8 && (double)pitch > 1.3333333333333333; ++octave) {
                    pitch /= 2.0f;
                }
                float factor = 0.5f;
                float adjustedVolume = (float)((double)volume / Math.sqrt((double)pitch * Math.pow(2.0, octave - 4)));
                volume = volume * (1.0f - factor) + adjustedVolume * factor;
                int length = this.findClosestLength(note.length());
                int soundEventIndexNote = SoundEvent.getAssetMap().getIndex((Object)"SFX_Ymmersive_Melodies_%s_C%s_%sms".formatted(this.instrument, octave, length));
                MelodyPlaybackInteraction.playSoundEvent3d(soundEventIndexNote, volume, pitch, SoundCategory.SFX, position, (ComponentAccessor<EntityStore>)store, delay);
            }
        }
        progress.worldTime = timeMs;
        progress.time += delta;
        ItemStack newItemInHand = itemInHand.withMetadata("MelodyProgress", MelodyProgress.CODEC, (Object)progress);
        ItemContainer container = context.getHeldItemContainer();
        if (container != null) {
            container.replaceItemStackInSlot((short)context.getHeldItemSlot(), itemInHand, newItemInHand);
        }
    }

    public static void playSoundEvent3d(int soundEventIndex, float volume, float pitch, SoundCategory soundCategory, Vector3d position, ComponentAccessor<EntityStore> componentAccessor, long delay) {
        SoundEvent soundevent = (SoundEvent)SoundEvent.getAssetMap().getAsset(soundEventIndex);
        if (soundevent == null) {
            return;
        }
        PlaySoundEvent3D soundEvent = new PlaySoundEvent3D(soundEventIndex, soundCategory, new Position(position.x, position.y, position.z), volume, pitch);
        SpatialResource spatialresource = (SpatialResource)componentAccessor.getResource(EntityModule.get().getPlayerSpatialResourceType());
        ObjectList list = SpatialResource.getThreadLocalReferenceList();
        spatialresource.getSpatialStructure().collect(position, (double)soundevent.getMaxDistance(), (List)list);
        for (Ref ref : list) {
            PlayerRef playerref = (PlayerRef)componentAccessor.getComponent(ref, PlayerRef.getComponentType());
            assert (playerref != null);
            executor.schedule(() -> playerref.getPacketHandler().write((Packet)soundEvent), delay, TimeUnit.MILLISECONDS);
        }
    }
}

