/*
 * Decompiled with CFR 0.152.
 */
package net.conczin.gui;

import com.hypixel.hytale.codec.Codec;
import com.hypixel.hytale.component.Ref;
import com.hypixel.hytale.component.Store;
import com.hypixel.hytale.protocol.packets.interface_.CustomPageLifetime;
import com.hypixel.hytale.protocol.packets.interface_.CustomUIEventBindingType;
import com.hypixel.hytale.server.core.Message;
import com.hypixel.hytale.server.core.entity.entities.Player;
import com.hypixel.hytale.server.core.entity.entities.player.pages.CustomUIPage;
import com.hypixel.hytale.server.core.ui.builder.EventData;
import com.hypixel.hytale.server.core.ui.builder.UICommandBuilder;
import com.hypixel.hytale.server.core.ui.builder.UIEventBuilder;
import com.hypixel.hytale.server.core.universe.PlayerRef;
import com.hypixel.hytale.server.core.universe.world.storage.EntityStore;
import java.io.InputStream;
import java.net.URI;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.conczin.data.Melody;
import net.conczin.data.MidiParser;
import net.conczin.data.YmmersiveMelodiesRegistry;
import net.conczin.gui.CodecDataInteractiveUIPage;
import net.conczin.gui.MelodySelectionGui;
import net.conczin.utils.RecordCodec;
import net.conczin.utils.Utils;

public class MelodyUploadGui
extends CodecDataInteractiveUIPage<Data> {
    public MelodyUploadGui(@Nonnull PlayerRef playerRef, @Nonnull CustomPageLifetime lifetime) {
        super(playerRef, lifetime, Data.CODEC);
    }

    public void build(@Nonnull Ref<EntityStore> ref, @Nonnull UICommandBuilder commandBuilder, @Nonnull UIEventBuilder eventBuilder, @Nonnull Store<EntityStore> store) {
        commandBuilder.append("Pages/YmmersiveMelodies/MelodyUpload.ui");
        eventBuilder.addEventBinding(CustomUIEventBindingType.Activating, "#Upload", new EventData().append("@Name", "#Name.Value").append("@Url", "#Url.Value"));
        eventBuilder.addEventBinding(CustomUIEventBindingType.Activating, "#Cancel", EventData.of((String)"Action", (String)"Cancel"));
    }

    @Override
    public void handleDataEvent(@Nonnull Ref<EntityStore> ref, @Nonnull Store<EntityStore> store, @Nonnull Data data) {
        super.handleDataEvent(ref, store, data);
        if (data.name != null && data.url != null) {
            try {
                URI uri;
                if (data.name.isBlank()) {
                    this.error("Name cannot be empty");
                    return;
                }
                UUID uuid = Utils.getUUID(ref);
                YmmersiveMelodiesRegistry resource = (YmmersiveMelodiesRegistry)store.getResource(YmmersiveMelodiesRegistry.getResourceType());
                if (resource.get(uuid, data.name) != null) {
                    this.error("A melody with this title already exists");
                    return;
                }
                String url = data.url.trim();
                if (url.isEmpty()) {
                    this.error("URL cannot be empty");
                    return;
                }
                boolean isLocal = false;
                if (url.startsWith("http://") || url.startsWith("https://")) {
                    uri = new URI(url);
                } else if (url.startsWith("file:")) {
                    isLocal = true;
                    uri = Paths.get(new URI(url)).toUri();
                } else if (url.matches("^[a-zA-Z]:\\\\.*") || url.startsWith("\\\\") || url.startsWith("/") || url.matches("^[a-zA-Z]:/.*")) {
                    isLocal = true;
                    uri = Path.of(url, new String[0]).toUri();
                } else {
                    this.error("Unsupported URL scheme");
                    return;
                }
                if (isLocal && !this.playerRef.getPacketHandler().isLocalConnection()) {
                    this.error("Local file uploads are only allowed when connected locally");
                    return;
                }
                try (InputStream in = uri.toURL().openStream();){
                    List<Melody.Track> tracks = MidiParser.parseMidi(in);
                    resource.add(uuid, new Melody(data.name, tracks));
                }
                MelodyUploadGui.returnToSelection(ref, store, data.name);
            }
            catch (Exception e) {
                this.error(e.getMessage());
                return;
            }
        }
        if ("Cancel".equals(data.action)) {
            MelodyUploadGui.returnToSelection(ref, store, "");
        }
    }

    private static void returnToSelection(Ref<EntityStore> ref, Store<EntityStore> store, String initialMelody) {
        Player player = (Player)store.getComponent(ref, Player.getComponentType());
        assert (player != null);
        PlayerRef playerRefComponent = (PlayerRef)store.getComponent(ref, PlayerRef.getComponentType());
        assert (playerRefComponent != null);
        MelodySelectionGui gui = new MelodySelectionGui(playerRefComponent, "", initialMelody);
        player.getPageManager().openCustomPage(ref, store, (CustomUIPage)gui);
    }

    private void error(String error) {
        UICommandBuilder commandBuilder = new UICommandBuilder();
        commandBuilder.set("#Details.Text", Message.translation((String)"customUI.melodyUpload.error").param("message", error == null ? "Unknown" : error));
        commandBuilder.set("#Details.Style.TextColor", "#ff0000");
        this.sendUpdate(commandBuilder, new UIEventBuilder(), false);
    }

    public record Data(String name, String url, String action) {
        public static final Codec<Data> CODEC = RecordCodec.composite("@Name", Codec.STRING, Data::name, "@Url", Codec.STRING, Data::url, "Action", Codec.STRING, Data::action, Data::new);
    }
}

